<p><?php echo __('Escolha como você deseja redirecionar o URL do WhatsApp.', 'ninjateam-whatsapp') ?></p>
<table class="form-table">
    <tbody>
        <tr>
            <th scope="row"><label for="nta-wa-switch-control"><?php echo __('Abrir em nova guia', 'ninjateam-whatsapp') ?></label></th>
            <td>
                <div class="nta-wa-switch-control">
                    <input type="checkbox" id="nta-wa-switch-open-new-tab" name="openInNewTab" <?php checked($option['openInNewTab'], 'ON') ?>>
                    <label for="nta-wa-switch-open-new-tab" class="green"></label>
                </div>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php echo __('URL para computador', 'ninjateam-whatsapp') ?></label></th>
            <td>
                <div class="button-group button-large" data-setting="onDesktop">
                    <button class="button btn-api <?php echo ($option['onDesktop'] == 'api' ? 'active' : '') ?>" value="api" type="button">
                        API
                    </button>
                    <button class="button btn-web <?php echo ($option['onDesktop'] == 'web' ? 'active' : '') ?>" value="web" type="button">
                        Web
                    </button>
                    <input name="onDesktop" id="urlOnDesktop" class="hidden" value="<?php echo esc_attr($option['onDesktop']) ?>" />
                </div>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php echo __('URL para celular', 'ninjateam-whatsapp') ?></label></th>
            <td>
                <div class="button-group button-large" data-setting="onMobile">
                    <button class="button btn-api <?php echo ($option['onMobile'] == 'api' ? 'active' : '') ?>" value="api" type="button">
                        API
                    </button>
                    <button class="button btn-protocol <?php echo ($option['onMobile'] == 'protocolo' ? 'active' : '') ?>" value="protocol" type="button">
                        Protocol
                    </button>
                    <input name="onMobile" id="urlOnMobile" class="hidden" value="<?php echo esc_attr($option['onMobile']) ?>" />
                </div>
            </td>
        </tr>
    </tbody>
</table>
<button class="button button-large button-primary wa-save"><?php echo __('Salvar alterações', 'ninjateam-whatsapp') ?><span></span></button>