<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Страница общих настроек для этого плагина.
 *
 * Не поддерживает режим работы с мультисаймами.
 *
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>, Github: https://github.com/alexkovalevv
 * @copyright (c) 2019 Webraftic Ltd
 * @version       1.0
 */
class WDANPRO_Edit_Admin_Bar extends WDAN_Edit_Admin_Bar {

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $id = "wdanp-edit-admin-bar";

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $type = "page";

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $page_menu_dashicon = 'dashicons-menu';

	/**
	 * {@inheritDoc}
	 *
	 * @since   2.0.5 - добавлен
	 * @var bool
	 */
	public $show_right_sidebar_in_options = false;


	/**
	 * @param WDN_Plugin $plugin
	 */
	public function __construct( $plugin ) {
		$this->menu_title                  = __( 'Hide adminbar items', 'disable-admin-notices' );
		$this->page_menu_short_description = __( 'You can hide an annoying adminbar menu', 'disable-admin-notices' );

		parent::__construct( $plugin );

		$this->plugin = $plugin;

		add_action( 'wp_before_admin_bar_render', [ $this, 'remove_from_admin_bar' ], 999 );
	}

	/**
	 * Enqueue page assets
	 *
	 * @return void
	 * @since 1.0.0
	 * @see   Wbcr_FactoryPages000_AdminPage
	 *
	 */

	/**
	 * Requests assets (js and css) for the page.
	 *
	 * @param Wbcr_Factory000_ScriptList $scripts
	 * @param Wbcr_Factory000_StyleList $styles
	 *
	 * @return void
	 * @see Wbcr_FactoryPages000_AdminPage
	 *
	 */
	public function assets( $scripts, $styles ) {
		parent::assets( $scripts, $styles );

		$this->styles->add( WDN_PLUGIN_URL . '/admin/assets/css/settings.css' );
		$this->scripts->add( WDANPRO_PLUGIN_URL . '/admin/assets/js/settings.js', [
			'jquery'
		] );
	}

	public function remove_from_admin_bar() {
		global $wp_admin_bar;

		if ( empty( $wp_admin_bar ) ) {
			return;
		}

		$hidden_items = $this->plugin->getPopulateOption( 'hidden_adminbar_items', [] );

		$nodes = [];
		foreach ( $wp_admin_bar->get_nodes() as $node ) {
			if ( false === $node->parent && ! empty( $node->title ) ) {
				if ( "updates" === $node->id ) {
					$node->title = "Updates";
				}
				if ( "comments" === $node->id ) {
					$node->title = "Comments";
				}
				$nodes[ $node->id ] = strip_tags( $node->title );
			}
		}

		$this->plugin->updatePopulateOption( 'adminbar_items', $nodes );

		foreach ( (array) $hidden_items as $item_ID => $bool ) {
			$wp_admin_bar->remove_menu( $item_ID );
		}
	}

	public function disableAdminbarItemAction() {
		$item_ID = $this->request()->get( 'id', null, 'sanitize_key' );
		check_admin_referer( 'disable_adminbar_item_' . $item_ID );

		$items = $this->plugin->getPopulateOption( 'hidden_adminbar_items', [] );

		if ( ! isset( $items[ $item_ID ] ) ) {
			$items[ $item_ID ] = true;
			$this->plugin->updatePopulateOption( 'hidden_adminbar_items', $items );
		}

		$this->redirectToAction( 'index' );
	}

	public function enableAdminbarItemAction() {
		$item_ID = $this->request()->get( 'id', null, 'sanitize_key' );
		check_admin_referer( 'enable_adminbar_item_' . $item_ID );

		$items = $this->plugin->getPopulateOption( 'hidden_adminbar_items', [] );

		if ( isset( $items[ $item_ID ] ) ) {
			unset( $items[ $item_ID ] );
			$this->plugin->updatePopulateOption( 'hidden_adminbar_items', $items );
		}

		$this->redirectToAction( 'index' );
	}

	public function showPageContent() {
		$all_items    = $this->plugin->getPopulateOption( 'adminbar_items', [] );
		$hidden_items = $this->plugin->getPopulateOption( 'hidden_adminbar_items', [] );

		?>

		<div style="padding:15px;">
			<h4>Disable adminbar items</h4>
			<table class="wp-list-table widefat fixed striped">
				<tr>
					<th><strong>Menu title</strong></th>
					<th style="width:150px;"><strong>Action</strong></th>
				</tr>
				<?php foreach ( (array) $all_items as $ID => $title ): ?>

					<tr>
						<td><?php echo $title; ?></td>
						<td>
							<div data-nonce="<?php echo wp_create_nonce( 'enable_adminbar_item_' . $ID ) ?>" data-menu-id="<?php echo esc_attr( $ID ); ?>" class="wdanpro-checkbox factory-checkbox factory-from-control-checkbox factory-buttons-way btn-group">
								<button type="button" class="btn btn-default btn-small btn-sm factory-on<?php if ( ! isset( $hidden_items[ $ID ] ) ): ?> active<?php else: ?><?php endif; ?>">
									On
								</button>
								<button type="button" class="btn btn-default btn-small btn-sm factory-off<?php if ( ! isset( $hidden_items[ $ID ] ) ): ?> active<?php else: ?><?php endif; ?>" data-value="0">
									Off
								</button>
								<input type="checkbox" style="display: none" class="factory-result" <?php if ( ! isset( $hidden_items[ $ID ] ) ): ?>value="1" checked="checked"<?php else: ?><?php endif; ?>>
							</div>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>

		<?php
	}

}
