'use strict';
(function ($) {
    if (typeof lodash === 'undefined') {
        return;
    }
    var isOverrideEnabled = wsAmeBrandingClsPreviewData.isOverrideEnabled;
    var forceEnablePreview = wsAmeBrandingClsPreviewData.forceEnablePreview;
    var currentColors = {};
    var $nodesToRemove = [];
    var $latestStylesheet = null;
    var updateColorPreview = lodash.throttle(function () {
        var colors = [];
        var hasCustomColors = false;
        for (var variableName in currentColors) {
            var color = currentColors[variableName];
            if ((color !== null) && (color !== '')) {
                hasCustomColors = true;
                var index = wsAmeBrandingClsPreviewData.colorVariableOrder[variableName];
                colors[index] = color.replace('#', '');
            }
        }
        //Preview is enabled only if the "is_color_override_enabled" setting is enabled
        //or if the special "force enable preview" setting is enabled. Preview is disabled
        //if there are no color settings.
        var isPreviewEnabled = (isOverrideEnabled || forceEnablePreview) && hasCustomColors;
        if (!isPreviewEnabled) {
            //Remove all preview stylesheets.
            $nodesToRemove.forEach(function ($node) {
                $node.remove();
            });
            $nodesToRemove = [];
            if ($latestStylesheet) {
                $latestStylesheet.remove();
                $latestStylesheet = null;
            }
            //Also remove the normal color scheme stylesheet generated by PHP
            //if it looks like it was added by this plugin.
            var $colorSchemeStyle = $('head link#colors-css');
            if ($colorSchemeStyle.length > 0) {
                var href = $colorSchemeStyle.attr('href');
                if (href && (href.indexOf('ame_branding_preview_colors')) !== -1) {
                    $colorSchemeStyle.remove();
                }
            }
            return;
        }
        var stylesheetUrl = wsAmeBrandingClsPreviewData.previewBaseUrl
            + '&colors=' + encodeURIComponent(colors.join('.'));
        var $stylesheet = $('<link/>', {
            'rel': 'stylesheet',
            'type': 'text/css',
            'href': stylesheetUrl
        });
        if ($latestStylesheet !== null) {
            $nodesToRemove.push($latestStylesheet);
        }
        $latestStylesheet = $stylesheet;
        $stylesheet.on('load', function () {
            if ($nodesToRemove.length > 0) {
                var remaining_1 = [];
                $nodesToRemove.forEach(function ($node) {
                    if ($node.is($stylesheet)) {
                        //Keep the current stylesheet until the next one loads and removes it.
                        //This helps avoid flicker when the user drags color sliders.
                        remaining_1.push($node);
                    }
                    else {
                        $node.remove();
                    }
                });
                $nodesToRemove = remaining_1;
            }
        });
        $stylesheet.appendTo('head');
    }, 1000);
    function registerPreviewUpdaters() {
        var _loop_1 = function (settingId) {
            var setting = wsAmeBrandingClsPreviewData.colorSettings[settingId];
            currentColors[setting.variableName] = setting.initialValue;
            wsAdminCustomizerPreview.registerPreviewer(settingId, function (newColor) {
                currentColors[setting.variableName] = newColor;
                updateColorPreview();
            });
        };
        //Initialize the current colors.
        for (var settingId in wsAmeBrandingClsPreviewData.colorSettings) {
            _loop_1(settingId);
        }
        //Watch for changes to the "color scheme override" setting.
        if (wsAmeBrandingClsPreviewData.overrideSettingId) {
            wsAdminCustomizerPreview.registerPreviewer(wsAmeBrandingClsPreviewData.overrideSettingId, function (newValue) {
                isOverrideEnabled = !!newValue;
                updateColorPreview();
            });
        }
        //Enable preview when the user enters the "Color Scheme" section. The "helper"
        //script (in the same directory) detects the section change and calls this method.
        wsAdminCustomizerPreview.registerRpcMethod('ameBrandingAdminColors.setForceEnablePreview', function (arg) {
            forceEnablePreview = !!arg;
            updateColorPreview();
        });
    }
    if (typeof wsAdminCustomizerPreview !== 'undefined') {
        registerPreviewUpdaters();
    }
    else {
        $(document).on('adminMenuEditor:acPreviewStart', function () {
            registerPreviewUpdaters();
        });
    }
})(jQuery);
//# sourceMappingURL=ac-color-scheme-preview.js.map